* rt-ssur2.prg
* v1.0
*
* Forecast unemployment rate using real-time data

calendar 1951 1 12
allocate 2100:12

declare integer FIRSTOBS LASTOBS ESTEND ESTBEG FCBEG FCEND FCLEN

open data input.csv
data(format=cdf, org=col) / E U s f hwi uic
close data

** locate last observation for UR
set ur = U/(U+E)
inquire(series=ur) FIRSTOBS LASTOBS
set urdata = ur

*************************************************
*** PARAMETERS FOR ESTIMATION AND FORECASTING ***
*************************************************
compute NLAGS=2;                    * Number of lags in VAR
compute ESTEND=LASTOBS;             * End date for VAR estimation
compute ESTBEG=ESTEND-179;          * Start date for VAR estimation
compute FCLEN=24;                   * Forecast length
compute FCBEG=ESTEND+1;             * Starting date for UR forecast
compute FCEND=FCBEG+FCLEN;          * Last date for which forecasts are desired


***************************************
*** ESTIMATE AND SIMULATE VAR MODEL ***
***************************************
* logs of variables
set ls = log(s{1})
set lf = log(f{1})
set lur = log(ur)
set dlur = log(ur/ur{1})
set luic = log(uic)
set lhwi = log(hwi)
set dlhwi = log(hwi/hwi{1})

* define VAR
system(model=ssur2)
variables ls lf dlur luic dlhwi
lags 1 to NLAGS
det constant
end(system)
*
estimate(model=ssur2) ESTBEG ESTEND
forecast(model=ssur2,from=FCBEG,to=FCEND+1,results=fcasts)

**************************************
*** UR FORECAST WITH PREDICTED S&F ***
**************************************
* add in flows forecats
set s FCBEG-1 FCEND = exp(fcasts(1){-1})
set f FCBEG-1 FCEND = exp(fcasts(2){-1})
* steady state unemployment rate
set ssur = s/(s+f)
* convergence speed
set beta = 1-exp(-f-s)
* iterate to create UR forecast
do t=FCBEG-1,FCEND
  set ur t t = beta(t)*ssur(t-1) + (1-beta(t))*ur(t-1)
end do
set ur * lastobs = urdata
*
print(picture="#.#####") FCBEG-1 FCEND s f ssur ur

********************************
*** STORE SERIES TO CSV FILE ***
********************************
open(noappend) copy output.csv
copy(format=cdf,dates,org=columns) / s f ur
close copy
